
        NAME  MiniGRiDInterface

; This module contains entrypoints for all of the MiniGRiD calls
; and enough code to get to the actual call.


padIntVect        EQU 060H
eLibraryNotLoaded EQU 8000H
apiNoLibExitError EQU 0FFH        ; ZZZ- This should be more meaningful !!!

_TEXT SEGMENT PUBLIC 'CODE'
  ASSUME CS:_TEXT

PUBLIC MniInitialize, MniTerminate, MniDebugInfo

PUBLIC CtlInitControl, CtlFreeControlInfo
PUBLIC CtlEnableControl, CtlDisableControl, CtlSetControlValue
PUBLIC CtlDrawControl, CtlControlPressed

PUBLIC EvtGetEvent, EvtAddEventToQueue, EvtCurrentTick
PUBLIC InsPtSetLocation, InsPtGetLocation
PUBLIC InsPtEnable, InsPtEnabled, InsPtSetHeight, InsPtGetHeight
PUBLIC InsPtCheckBlink, InsPtSetBlinkInterval

PUBLIC FldInitField, FldFreeFieldMemory, FldSetFieldText
PUBLIC FldDrawField, FldEraseField, FldCut, FldCopy, FldPaste
PUBLIC FldStartSelection, FldCancelSelection
PUBLIC FldHandleKbKey, FldHandlePenChars
PUBLIC FldAllocateScrapMemory, FldFreeScrapMemory, FldGetScrap, FldSetScrap
PUBLIC FldSetInsPtPosition, FldSetInsPtLocation

PUBLIC FrmInitForm, FrmDisposeForm, FrmDrawForm, FrmEraseForm
PUBLIC FrmSetActiveForm, FrmFormChanged, FrmResetChangedState
PUBLIC FrmGetControlIndex, FrmGetFieldIndex, FrmGetListIndex
PUBLIC FrmGetControlPtr, FrmGetFieldPtr, FrmGetListPtr
PUBLIC FrmGetCurrentField, FrmSetCurrentField
PUBLIC FrmGetControlValue, FrmSetControlValue 
PUBLIC FrmGetListChoice, FrmSetListChoice, FrmGetFieldValue, FrmSetFieldValue
PUBLIC FrmSetProperty, FrmHandleEvent 

PUBLIC LstInitList, LstFreeListMemory, LstDrawList, LstEraseList
PUBLIC LstGetCurrentChoice, LstSetCurrentChoice
PUBLIC LstGetChoiceText, LstFindItem, LstStartSelection

PUBLIC OvlOverlayInit, OvlOverlayTerminate, OvlGetPt, OvlGetPtAndPen
PUBLIC OvlOverlayToDisplayPt, OvlSetOverlayOrientation

PUBLIC RscOpenResourceFile, RscCloseResourceFile
PUBLIC RscGetResource, RscGetResourceCopy, RscFreeResource
PUBLIC RscGetResourceString, RscGetResourceStringCopy

PUBLIC WinCreateWindow, WinCreateOffscreenWindow
PUBLIC WinDeleteWindow, WinSetDisplayOrientation
PUBLIC WinSetDrawWindow, WinSetActiveWindow
PUBLIC WinGetDrawWindow, WinGetActiveWindow
PUBLIC WinGetDisplayWindow, WinEnableWindow
PUBLIC WinDisableWindow, WinGetWindowsPointer

PUBLIC WinGetWindowFrameRect, WinDrawWindowFrame
PUBLIC WinEraseWindow, WinSaveBits, WinRestoreBits
PUBLIC WinCopyRectangle, WinScrollRectangle

PUBLIC WinGetDisplayExtent, WinGetWindowExtent
PUBLIC WinDisplayToWindowPt, WinWindowToDisplayPt
PUBLIC WinSetPattern, WinSetPtnXferMode
PUBLIC WinGetPattern, WinGetPtnXferMode
PUBLIC WinSetClip, WinGetClip, WinClipRectangle

PUBLIC WinTestPixel, WinDrawPixel, WinErasePixel
PUBLIC WinInvertPixel, WinPatternPixel
PUBLIC WinDrawLine, WinEraseLine, WinInvertLine, WinPatternLine
PUBLIC WinDrawRectangle, WinEraseRectangle
PUBLIC WinInvertRectangle, WinPatternRectangle
PUBLIC WinDrawRectangleFrame, WinEraseRectangleFrame
PUBLIC WinInvertRectangleFrame, WinPatternRectangleFrame

PUBLIC RctSetRectangle, RctCopyRectangles
PUBLIC RctInsetRectangle, RctOffsetRectangle
PUBLIC RctRectanglesIntersect, RctPtInRectangle, RctGetFramesRectangle

PUBLIC FntLoadFont, FntSetFont
PUBLIC FntProportionalFont, FntBaseLine
PUBLIC FntCharHeight, FntLineHeight
PUBLIC FntAverageCharWidth, FntCharWidth, FntCharsWidth

PUBLIC WinDrawChars, WinDrawGrayChars
PUBLIC WinEraseChars, WinInvertChars, WinPatternChars

PUBLIC CsrTurnCursorOn, CsrTurnCursorOff
PUBLIC CsrMoveCursor, CsrSetCursor

saveIP	        DW  ?
saveDS	        DW  ?
saveDI           DW  ?
saveSI           DW  ?

apiEntrypoint    DD  ?

apiLibraryExists DB  0
apiSignatureText DB  11, 'GRiDPad API'
apiSignatureLen  EQU 12


MniInitialize LABEL NEAR
 XOR  AX, AX
 MOV  ES, AX                      ; Segment of interrupt vectors
 MOV  DI, padIntVect
 SHL  DI, 1
 SHL  DI, 1                       ; Four bytes per interrupt entry
 LES  DI, DWORD PTR ES:[DI]
 INC  DI                          ; Indirect entrypoint is at offset
 INC  DI                          ; 2 from interrupt entrypoint
 MOV  WORD PTR CS:apiEntrypoint+2, ES
 MOV  WORD PTR CS:apiEntrypoint+0, DI

 PUSH DS
 MOV  AX, CS
 MOV  DS, AX
 LEA  SI, CS:apiSignatureText
 INC  DI                          ; Signature is stored at offset
 INC  DI                          ; 4 from interrupt entrypoint
 MOV  CX, apiSignatureLen
 CLD
 REP  CMPSB
 POP  DS
 JE   MniInitLibExists

 MOV  AX, eLibraryNotLoaded
 RET

MniInitLibExists:
 MOV  CS:apiLibraryExists, 1
 MOV  AL, 0
 JMP  CallMiniGRiD


MniTerminate LABEL NEAR
 CMP  CS:apiLibraryExists, 1      ; If the library exists
 JE   MniTermLibExists            ; then call it and reset the existence flag

 RET                              ; Else just return to the caller

MniTermLibExists:
 MOV  CS:apiLibraryExists, 0      ; Reset the apiLibraryExists flag
 MOV  AL, 1                       ; Send APITerminate request to library
 JMP  CallMiniGRiDFromTerminate   ; Already checked for library existence


; Entrypoint number 2 is used to tell the library to remove itself from
; memory and is not intended to be called via this interface mechanism.


; Entrypoint number 3 is used to communicate with the library to get any
; kind of debugging information or to set debug flags.  It is currently
; used to get back the free memory, but needs to be made more general purpose.

MniDebugInfo LABEL NEAR
 MOV  AL, 3
CallMiniGRiDHop1:
 JMP  CallMiniGRiD


CtlInitControl LABEL NEAR
 MOV  AL, 4
 JMP  SHORT CallMiniGRiDHop1

CtlFreeControlInfo LABEL NEAR
 MOV  AL, 5
 JMP  SHORT CallMiniGRiDHop1

CtlEnableControl LABEL NEAR
 MOV  AL, 6
 JMP  SHORT CallMiniGRiDHop1

CtlDisableControl LABEL NEAR
 MOV  AL, 7
 JMP  SHORT CallMiniGRiDHop1

CtlSetControlValue LABEL NEAR
 MOV  AL, 8
 JMP  SHORT CallMiniGRiDHop1

CtlDrawControl LABEL NEAR
 MOV  AL, 9
 JMP  SHORT CallMiniGRiDHop1

CtlControlPressed LABEL NEAR
 MOV  AL, 10
 JMP  SHORT CallMiniGRiDHop1


EvtGetEvent LABEL NEAR
 MOV  AL, 11
 JMP  SHORT CallMiniGRiDHop1

EvtAddEventToQueue LABEL NEAR
 MOV  AL, 12
 JMP  SHORT CallMiniGRiDHop1

EvtCurrentTick LABEL NEAR
 MOV  AL, 13
 JMP  SHORT CallMiniGRiDHop1

InsPtSetLocation LABEL NEAR
 MOV  AL, 14
 JMP  SHORT CallMiniGRiDHop1

InsPtGetLocation LABEL NEAR
 MOV  AL, 15
 JMP  SHORT CallMiniGRiDHop1

InsPtEnable LABEL NEAR
 MOV  AL, 16
 JMP  SHORT CallMiniGRiDHop1

InsPtEnabled LABEL NEAR
 MOV  AL, 17
 JMP  SHORT CallMiniGRiDHop1

InsPtSetHeight LABEL NEAR
 MOV  AL, 18
 JMP  SHORT CallMiniGRiDHop1

InsPtGetHeight LABEL NEAR
 MOV  AL, 19
 JMP  SHORT CallMiniGRiDHop1


FldInitField LABEL NEAR
 MOV  AL, 20
 JMP  SHORT CallMiniGRiDHop1

FldFreeFieldMemory LABEL NEAR
 MOV  AL, 21
 JMP  SHORT CallMiniGRiDHop1

FldSetFieldText LABEL NEAR
 MOV  AL, 22
 JMP  SHORT CallMiniGRiDHop1

FldDrawField LABEL NEAR
 MOV  AL, 23
 JMP  SHORT CallMiniGRiDHop1

FldEraseField LABEL NEAR
 MOV  AL, 24
 JMP  SHORT CallMiniGRiDHop1

FldCut LABEL NEAR
 MOV  AL, 25
 JMP  SHORT CallMiniGRiDHop1

FldCopy LABEL NEAR
 MOV  AL, 26
 JMP  SHORT CallMiniGRiDHop1

FldPaste LABEL NEAR
 MOV  AL, 27
 JMP  SHORT CallMiniGRiDHop1

FldStartSelection LABEL NEAR
 MOV  AL, 28
 JMP  SHORT CallMiniGRiDHop1

FldCancelSelection LABEL NEAR
 MOV  AL, 29
 JMP  SHORT CallMiniGRiDHop1

FldHandleKbKey LABEL NEAR
 MOV  AL, 30
 JMP  SHORT CallMiniGRiDHop1

FldHandlePenChars LABEL NEAR
 MOV  AL, 31
 JMP  SHORT CallMiniGRiDHop1

FldAllocateScrapMemory LABEL NEAR
 MOV  AL, 32
 JMP  SHORT CallMiniGRiDHop1

FldFreeScrapMemory LABEL NEAR
 MOV  AL, 33
 JMP  SHORT CallMiniGRiDHop1

FldGetScrap LABEL NEAR
 MOV  AL, 34
 JMP  SHORT CallMiniGRiDHop2

FldSetScrap LABEL NEAR
 MOV  AL, 35
 JMP  SHORT CallMiniGRiDHop2

FldSetInsPtPosition LABEL NEAR
 MOV  AL, 36
 JMP  SHORT CallMiniGRiDHop2

FldSetInsPtLocation LABEL NEAR
 MOV  AL, 37
 JMP  SHORT CallMiniGRiDHop2


FrmInitForm LABEL NEAR
 MOV  AL, 38
 JMP  SHORT CallMiniGRiDHop2

FrmDisposeForm LABEL NEAR
 MOV  AL, 39
 JMP  SHORT CallMiniGRiDHop2

FrmDrawForm LABEL NEAR
 MOV  AL, 40
 JMP  SHORT CallMiniGRiDHop2

FrmEraseForm LABEL NEAR
 MOV  AL, 41
 JMP  SHORT CallMiniGRiDHop2

FrmSetActiveForm LABEL NEAR
 MOV  AL, 42
 JMP  SHORT CallMiniGRiDHop2

FrmFormChanged LABEL NEAR
 MOV  AL, 43
 JMP  SHORT CallMiniGRiDHop2

FrmResetChangedState LABEL NEAR
 MOV  AL, 44
 JMP  SHORT CallMiniGRiDHop2

FrmGetControlIndex LABEL NEAR
 MOV  AL, 45
 JMP  SHORT CallMiniGRiDHop2

FrmGetFieldIndex LABEL NEAR
 MOV  AL, 46
 JMP  SHORT CallMiniGRiDHop2

FrmGetListIndex LABEL NEAR
 MOV  AL, 47
 JMP  SHORT CallMiniGRiDHop2

FrmGetControlPtr LABEL NEAR
 MOV  AL, 48
 JMP  SHORT CallMiniGRiDHop2

FrmGetFieldPtr LABEL NEAR
 MOV  AL, 49
 JMP  SHORT CallMiniGRiDHop2

FrmGetListPtr LABEL NEAR
 MOV  AL, 50
 JMP  SHORT CallMiniGRiDHop2

FrmGetCurrentField LABEL NEAR
 MOV  AL, 51
 JMP  SHORT CallMiniGRiDHop2

FrmSetCurrentField LABEL NEAR
 MOV  AL, 52
 JMP  SHORT CallMiniGRiDHop2

FrmGetControlValue LABEL NEAR
 MOV  AL, 53
 JMP  SHORT CallMiniGRiDHop2

FrmSetControlValue LABEL NEAR
 MOV  AL, 54
 JMP  SHORT CallMiniGRiDHop2

FrmGetListChoice LABEL NEAR
 MOV  AL, 55
 JMP  SHORT CallMiniGRiDHop2

FrmSetListChoice LABEL NEAR
 MOV  AL, 56
 JMP  SHORT CallMiniGRiDHop2

FrmGetFieldValue LABEL NEAR
 MOV  AL, 57
 JMP  SHORT CallMiniGRiDHop2

FrmSetFieldValue LABEL NEAR
 MOV  AL, 58
 JMP  SHORT CallMiniGRiDHop2

FrmSetProperty LABEL NEAR
 MOV  AL, 59
 JMP  SHORT CallMiniGRiDHop2

FrmHandleEvent LABEL NEAR
 MOV  AL, 60
 JMP  SHORT CallMiniGRiDHop2


LstInitList LABEL NEAR
 MOV  AL, 61
 JMP  SHORT CallMiniGRiDHop2

LstFreeListMemory LABEL NEAR
 MOV  AL, 62
 JMP  SHORT CallMiniGRiDHop2

LstDrawList LABEL NEAR
 MOV  AL, 63
 JMP  SHORT CallMiniGRiDHop2

LstEraseList LABEL NEAR
 MOV  AL, 64
 JMP  SHORT CallMiniGRiDHop2

LstGetCurrentChoice LABEL NEAR
 MOV  AL, 65
 JMP  SHORT CallMiniGRiDHop2

LstSetCurrentChoice LABEL NEAR
 MOV  AL, 66
CallMiniGRiDHop2:
 JMP  CallMiniGRiD

LstGetChoiceText LABEL NEAR
 MOV  AL, 67
 JMP  SHORT CallMiniGRiDHop2

LstFindItem LABEL NEAR
 MOV  AL, 68
 JMP  SHORT CallMiniGRiDHop2

LstStartSelection LABEL NEAR
 MOV  AL, 69
 JMP  SHORT CallMiniGRiDHop2


OvlOverlayInit LABEL NEAR
 MOV  AL, 70
 JMP  SHORT CallMiniGRiDHop2

OvlOverlayTerminate LABEL NEAR
 MOV  AL, 71
 JMP  SHORT CallMiniGRiDHop2

OvlGetPt LABEL NEAR
 MOV  AL, 72
 JMP  SHORT CallMiniGRiDHop2

OvlGetPtAndPen LABEL NEAR
 MOV  AL, 73
 JMP  SHORT CallMiniGRiDHop2

OvlOverlayToDisplayPt LABEL NEAR
 MOV  AL, 74
 JMP  SHORT CallMiniGRiDHop2

OvlSetOverlayOrientation LABEL NEAR
 MOV  AL, 75
 JMP  SHORT CallMiniGRiDHop2


RscOpenResourceFile LABEL NEAR
 MOV  AL, 76
 JMP  SHORT CallMiniGRiDHop2

RscCloseResourceFile LABEL NEAR
 MOV  AL, 77
 JMP  SHORT CallMiniGRiDHop2

RscGetResource LABEL NEAR
 MOV  AL, 78
 JMP  SHORT CallMiniGRiDHop2

RscGetResourceCopy LABEL NEAR
 MOV  AL, 79
 JMP  SHORT CallMiniGRiDHop2

RscFreeResource LABEL NEAR
 MOV  AL, 80
 JMP  SHORT CallMiniGRiDHop2

RscGetResourceString LABEL NEAR
 MOV  AL, 81
 JMP  SHORT CallMiniGRiDHop2

RscGetResourceStringCopy LABEL NEAR
 MOV  AL, 82
 JMP  SHORT CallMiniGRiDHop2


WinCreateWindow LABEL NEAR
 MOV  AL, 83
 JMP  SHORT CallMiniGRiDHop2

WinCreateOffscreenWindow LABEL NEAR
 MOV  AL, 84
 JMP  SHORT CallMiniGRiDHop2

WinDeleteWindow LABEL NEAR
 MOV  AL, 85
 JMP  SHORT CallMiniGRiDHop2

WinSetDisplayOrientation LABEL NEAR
 MOV  AL, 86
 JMP  SHORT CallMiniGRiDHop2

WinSetDrawWindow LABEL NEAR
 MOV  AL, 87
 JMP  SHORT CallMiniGRiDHop2

WinSetActiveWindow LABEL NEAR
 MOV  AL, 88
 JMP  SHORT CallMiniGRiDHop2

WinGetDrawWindow LABEL NEAR
 MOV  AL, 89
 JMP  SHORT CallMiniGRiDHop2

WinGetActiveWindow LABEL NEAR
 MOV  AL, 90
 JMP  SHORT CallMiniGRiDHop2

WinGetDisplayWindow LABEL NEAR
 MOV  AL, 91
 JMP  SHORT CallMiniGRiDHop2

WinEnableWindow LABEL NEAR
 MOV  AL, 92
 JMP  SHORT CallMiniGRiDHop2

WinDisableWindow LABEL NEAR
 MOV  AL, 93
 JMP  SHORT CallMiniGRiDHop2

WinGetWindowsPointer LABEL NEAR
 MOV  AL, 94
 JMP  SHORT CallMiniGRiDHop2


WinGetWindowFrameRect LABEL NEAR
 MOV  AL, 95
 JMP  SHORT CallMiniGRiDHop2

WinDrawWindowFrame LABEL NEAR
 MOV  AL, 96
 JMP  SHORT CallMiniGRiDHop2

WinEraseWindow LABEL NEAR
 MOV  AL, 97
 JMP  SHORT CallMiniGRiDHop2

WinSaveBits LABEL NEAR
 MOV  AL, 98
 JMP  SHORT CallMiniGRiDHop3

WinRestoreBits LABEL NEAR
 MOV  AL, 99
 JMP  SHORT CallMiniGRiDHop3

WinCopyRectangle LABEL NEAR
 MOV  AL, 100
 JMP  SHORT CallMiniGRiDHop3

WinScrollRectangle LABEL NEAR
 MOV  AL, 101
 JMP  SHORT CallMiniGRiDHop3


WinGetDisplayExtent LABEL NEAR
 MOV  AL, 102
 JMP  SHORT CallMiniGRiDHop3

WinGetWindowExtent LABEL NEAR
 MOV  AL, 103
 JMP  SHORT CallMiniGRiDHop3

WinDisplayToWindowPt LABEL NEAR
 MOV  AL, 104
 JMP  SHORT CallMiniGRiDHop3

WinWindowToDisplayPt LABEL NEAR
 MOV  AL, 105
 JMP  SHORT CallMiniGRiDHop3

WinSetPattern LABEL NEAR
 MOV  AL, 106
 JMP  SHORT CallMiniGRiDHop3

WinSetPtnXferMode LABEL NEAR
 MOV  AL, 107
 JMP  SHORT CallMiniGRiDHop3

WinGetPattern LABEL NEAR
 MOV  AL, 108
 JMP  SHORT CallMiniGRiDHop3

WinGetPtnXferMode LABEL NEAR
 MOV  AL, 109
 JMP  SHORT CallMiniGRiDHop3

WinSetClip LABEL NEAR
 MOV  AL, 110
 JMP  SHORT CallMiniGRiDHop3

WinGetClip LABEL NEAR
 MOV  AL, 111
 JMP  SHORT CallMiniGRiDHop3

WinClipRectangle LABEL NEAR
 MOV  AL, 112
 JMP  SHORT CallMiniGRiDHop3


WinTestPixel LABEL NEAR
 MOV  AL, 113
 JMP  SHORT CallMiniGRiDHop3

WinDrawPixel LABEL NEAR
 MOV  AL, 114
 JMP  SHORT CallMiniGRiDHop3

WinErasePixel LABEL NEAR
 MOV  AL, 115
 JMP  SHORT CallMiniGRiDHop3

WinInvertPixel LABEL NEAR
 MOV  AL, 116
 JMP  SHORT CallMiniGRiDHop3

WinPatternPixel LABEL NEAR
 MOV  AL, 117
 JMP  SHORT CallMiniGRiDHop3

WinDrawLine LABEL NEAR
 MOV  AL, 118
 JMP  SHORT CallMiniGRiDHop3

WinEraseLine LABEL NEAR
 MOV  AL, 119
 JMP  SHORT CallMiniGRiDHop3

WinInvertLine LABEL NEAR
 MOV  AL, 120
 JMP  SHORT CallMiniGRiDHop3

WinPatternLine LABEL NEAR
 MOV  AL, 121
 JMP  SHORT CallMiniGRiDHop3

WinDrawRectangle LABEL NEAR
 MOV  AL, 122
 JMP  SHORT CallMiniGRiDHop3

WinEraseRectangle LABEL NEAR
 MOV  AL, 123
 JMP  SHORT CallMiniGRiDHop3

WinInvertRectangle LABEL NEAR
 MOV  AL, 124
 JMP  SHORT CallMiniGRiDHop3

WinPatternRectangle LABEL NEAR
 MOV  AL, 125
 JMP  SHORT CallMiniGRiDHop3

WinDrawRectangleFrame LABEL NEAR
 MOV  AL, 126
 JMP  SHORT CallMiniGRiDHop3

WinEraseRectangleFrame LABEL NEAR
 MOV  AL, 127
 JMP  SHORT CallMiniGRiDHop3

WinInvertRectangleFrame LABEL NEAR
 MOV  AL, 128
 JMP  SHORT CallMiniGRiDHop3

WinPatternRectangleFrame LABEL NEAR
 MOV  AL, 129
CallMiniGRiDHop3:
 JMP  CallMiniGRiD


RctSetRectangle LABEL NEAR
 MOV  AL, 130
 JMP  SHORT CallMiniGRiD

RctCopyRectangles LABEL NEAR
 MOV  AL, 131
 JMP  SHORT CallMiniGRiD

RctInsetRectangle LABEL NEAR
 MOV  AL, 132
 JMP  SHORT CallMiniGRiD

RctOffsetRectangle LABEL NEAR
 MOV  AL, 133
 JMP  SHORT CallMiniGRiD

RctRectanglesIntersect LABEL NEAR
 MOV  AL, 134
 JMP  SHORT CallMiniGRiD

RctPtInRectangle LABEL NEAR
 MOV  AL, 135
 JMP  SHORT CallMiniGRiD

RctGetFramesRectangle LABEL NEAR
 MOV  AL, 136
 JMP  SHORT CallMiniGRiD


FntLoadFont LABEL NEAR
 MOV  AL, 137
 JMP  SHORT CallMiniGRiD

FntSetFont LABEL NEAR
 MOV  AL, 138
 JMP  SHORT CallMiniGRiD

FntProportionalFont LABEL NEAR
 MOV  AL, 139
 JMP  SHORT CallMiniGRiD

FntBaseLine LABEL NEAR
 MOV  AL, 140
 JMP  SHORT CallMiniGRiD

FntCharHeight LABEL NEAR
 MOV  AL, 141
 JMP  SHORT CallMiniGRiD

FntLineHeight LABEL NEAR
 MOV  AL, 142
 JMP  SHORT CallMiniGRiD

FntAverageCharWidth LABEL NEAR
 MOV  AL, 143
 JMP  SHORT CallMiniGRiD

FntCharWidth LABEL NEAR
 MOV  AL, 144
 JMP  SHORT CallMiniGRiD

FntCharsWidth LABEL NEAR
 MOV  AL, 145
 JMP  SHORT CallMiniGRiD


WinDrawChars LABEL NEAR
 MOV  AL, 146
 JMP  SHORT CallMiniGRiD

WinDrawGrayChars LABEL NEAR
 MOV  AL, 147
 JMP  SHORT CallMiniGRiD

WinEraseChars LABEL NEAR
 MOV  AL, 148
 JMP  SHORT CallMiniGRiD

WinInvertChars LABEL NEAR
 MOV  AL, 149
 JMP  SHORT CallMiniGRiD

WinPatternChars LABEL NEAR
 MOV  AL, 150
 JMP  SHORT CallMiniGRiD


CsrTurnCursorOn LABEL NEAR
 MOV  AL, 151
 JMP  SHORT CallMiniGRiD

CsrTurnCursorOff LABEL NEAR
 MOV  AL, 152
 JMP  SHORT CallMiniGRiD

CsrMoveCursor LABEL NEAR
 MOV  AL, 153
 JMP  SHORT CallMiniGRiD

CsrSetCursor LABEL NEAR
 MOV  AL, 154
 JMP  SHORT CallMiniGRiD

InsPtCheckBlink LABEL NEAR
 MOV  AL, 155
 JMP  SHORT CallMiniGRiD

InsPtSetBlinkInterval LABEL NEAR
 MOV  AL, 156
;JMP  SHORT CallMiniGRiD


CallMiniGRiD:
 CMP  CS:apiLibraryExists, 1
 JNE  CallMiniGRiDError

CallMiniGRiDFromTerminate:
 XOR  AH, AH
 POP  CS:saveIP
 MOV  CS:saveDS, DS
 MOV  CS:saveDI, DI
 MOV  CS:saveSI, SI

 CALL CS:apiEntrypoint

 CLD                             ; Caller expects direction flag to be cleared
 MOV  DI, CS:saveDI
 MOV  SI, CS:saveSI
 MOV  DS, CS:saveDS
 JMP  CS:saveIP


miniGRiDErrMsg DB 'GRiDPad library not present or initialized', 0DH, 0AH, '$'

CallMiniGRiDError:
 PUSH CS
 POP  DS
 LEA  DX, CS:miniGRiDErrMsg
 MOV  AH, 9
 INT  21H                ; Display error message to user
 MOV  AH, 4CH
 MOV  AL, apiNoLibExitError
 INT  21H                ; Exit MsDos program w/error return


_TEXT    ENDS

        END
